/* Antarmuka dengan Sensor Cahaya BH1750 - Trainer Internet of Things
 * Project : IoT Light Meter dengan Sensor Cahaya BH1750
 * Created By Electins.id
 * https://www.electins.id | https://www.instagram.com/electins.id/
 */

// Library ESP8266 WiFi dan Firebase ESP8266
#include <ESP8266WiFi.h>
#include <FirebaseESP8266.h>
// Library LCD 16x2 I2C
#include <Wire.h> 
#include <LiquidCrystal_I2C.h>
// Library Sensor BH 1750
#include <BH1750.h>

// SSID dan Password WiFi
#define WIFI_SSID "SSID_WIFI"
#define WIFI_PASSWORD "PASS_WIFI"

// URL Firebase dan Token Database
#define DATABASE_URL "project_id.firebaseio.com"
#define API_KEY "database_secret"

// Firebase objek dengan nama fbdo
FirebaseData fbdo;
// LCD Objek dengan nama lcd, alamat I2C 0x27, karakter 16x2
LiquidCrystal_I2C lcd(0x27,16,2);
// BH1750 Objek dengan nama lightMeter
BH1750 lightMeter;

// Nama pengguna pada Aplikasi IoT KIT
String user = "user_id";

// Variabel untuk menyimpan data pembacaan sensor
unsigned int lux;
// Variabel untuk menyimpan karakter data sensor 
char light[16];

void setup() {
  // Serial Monitor pada baudrate 115200
  Serial.begin(115200);

  Wire.begin();       // Memulai koneksi I2C
  lightMeter.begin(); // Memulai komunikasi sensor BH1750
  
  lcd.init();        // Inisialisasi LCD
  lcd.backlight();   // Menyalakan Backlight LCD
  // Menampilkan Teks pada LCD
  lcd.setCursor(0,0); lcd.print("Trainer Kit IoT");  
  lcd.setCursor(0,1); lcd.print("Connecting-WiFi");
  
  // Memulai koneksi WiFi
  WiFi.begin(WIFI_SSID, WIFI_PASSWORD);
  Serial.print("Connecting to Wi-Fi");
  while (WiFi.status() != WL_CONNECTED)
  {
    Serial.print(".");
    delay(300);
  }
  // Menampilkan status koneksi dan alamat IP
  Serial.println();
  Serial.print("Connected with IP: ");
  Serial.println(WiFi.localIP());
  Serial.println();
  
  // Menampilkan versi client firebase
  Serial.printf("Firebase Client v%s\n\n", FIREBASE_CLIENT_VERSION);
  // Memulai koneksi dengan dengan database
  // Re-koneksi jika WiFi terputus
  Firebase.begin(DATABASE_URL, API_KEY);
  Firebase.reconnectWiFi(true);

  delay(2000);      // Jeda tampilan teks pada LCD
  lcd.clear();      // Membersihkan tampilan LCD
}

void loop() { 
  // Melakukan pembacaan pada sensor
  // Data pembacaan di simpan pada 'lux'
  lux = lightMeter.readLightLevel();

  // Mencetak data sensor pada LCD 16x2 I2C
  sprintf(light, "LIGHT:%5d lx", lux);
  lcd.setCursor(0,0); lcd.print("Light Meter (lx)");
  lcd.setCursor(0,1); lcd.print(light);
  
  // Mencetak data sensor pada serial monitor
  Serial.print("Cahaya : " + String(lux) + " %");
  Serial.println();

  // Mengirim data sensor ke database
  // dengan alamat *user/gauge1
  Firebase.setInt(fbdo, "/" + user + "/gauge1", lux);
  
  // Jeda 150 ms agar perubahan nilai lebih halus 
  delay(150); 
}
